import matplotlib.pyplot as plt
import numpy as np
import scipy.signal as sig

cutoff_freq = 5000
filter_order = 5
filter_type = 'lowpass'
#filter_type = 'highpass'

#cutoff_freq=(5000,8000)
#filter_order = 5
#filter_type = 'bandpass'
#filter_type = 'bandstop'

start, stop = 0, 1
samp_freq = 40000
num = samp_freq
nyquist_freq = samp_freq//2

t = np.linspace(start, stop, num, endpoint=False)

amp = []
freq = list(range(100, nyquist_freq, 100))

for f in freq:

    y = np.sqrt(2)*np.cos(2*np.pi*f*t)
    
    sos = sig.butter(filter_order, cutoff_freq, 
                     filter_type, fs=samp_freq, 
                     output='sos')
    filtered_y = sig.sosfilt(sos, y)
    rms = np.sqrt(np.mean(filtered_y**2))
    amp.append(rms)

plt.xlabel('Frequency (Hz)')
plt.ylabel('Filter Output RMS Amplitude')

plt.plot(freq, amp, marker='o')
plt.show()
